/*
 * Copyright (c) 2008-2014, RF-Embedded GmbH
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, 
 * are permitted provided that the following conditions are met:
 * 
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice, 
 *     this list of conditions and the following disclaimer in the 
 *     documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT 
 * SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT 
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR 
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package com.rfe.test;

import com.rfe.device.IProtocolDeviceInterface;
import com.rfe.protocol.JrfeProtocolHandler;

/**
 * This class is meant to hold your own test routines
 * Just implement the test routines and show them via printTestTableExtended and call them via callTestRoutinesExtended
 */
public class TestProgramExtended extends TestProgram{

	/**
	 * Constructs the test extended program
	 */
    public TestProgramExtended()
    {
        _testTraceLevel = 0;
    }

    /**
     * Implement this function to create a communication device without being queried in the console.
     * @return		Returns the communication device.
     */
    public IProtocolDeviceInterface getTestDevice()
    {
        // Place your code here if you have always the same communication device for your test and you don't want to be queried
        return null;
    }

    /**
     * Implement this function to specify a reader type without being queried in the console.
     * @return
     */
    public ReaderType getTestType()
    {
        // Place your code here if you have always the same implementation type for your test and you don't want to be queried
        return null;
    }

    /**
     * Implement this function to create an own instance of the protocol handler class.
     * @param device	The communication device to the reader
     * @return			Returns the new instance, null if none was created.
     */
    protected JrfeProtocolHandler createInstanceExtended(IProtocolDeviceInterface device)
    {
        // Place your code here to create your own protocol handler implementation
        return null;
    }

    /**
     * Implement this function to add an own function to the test table output.
     */
    protected void printTestTableExtended()
    {
        // Place your code here to print the menu for your own test routine to the console
    }

    /**
     * Implement this function so your own function can be called
     * @param id		ID of your own functions
     * @return			Returns if a function with this id is implemented.
     */
    protected boolean callTestRoutinesExtended(int id)
    {
        // Place your code here to call your own test routine
        return false;
    }
}
